<?php
function generateSchema($url, $h1, $title, $description) {
    $domain = $_SERVER['HTTP_HOST'];
    $fullUrl = 'https://' . $domain . '/' . ltrim($url, '/') . (substr($url, -1) !== '/' ? '/' : '');
    $logo = 'https://' . $domain . '/logo.svg';
    $isoDate = date('c'); // Пример: 2025-05-16T17:57:23+03:00

    // 🔹 Хэш для генерации имени
    $hash = crc32($domain);
    $randDigits = abs((int)($hash % 10000000));
    $randDigitsStr = str_pad($randDigits, 7, '0', STR_PAD_LEFT);
    $phone = "+7-495-$randDigitsStr";

    // 🔹 Разделение домена
    $domainParts = explode('.', $domain);
    $domainShort = $domainParts[0];
    $domainZone = substr($domain, 0, 2);

    // 🔹 ФИО по хешу
    $firstNames = ["Иван", "Сергей", "Алексей", "Дмитрий", "Михаил", "Николай", "Андрей", "Евгений"];
    $lastNames  = ["Петров", "Иванов", "Сидоров", "Кузнецов", "Смирнов", "Фёдоров", "Алексеев", "Морозов"];
    $person1 = $firstNames[($hash + 1) % count($firstNames)] . ' ' . $lastNames[($hash + 2) % count($lastNames)];
    $person2 = $firstNames[($hash + 3) % count($firstNames)] . ' ' . $lastNames[($hash + 4) % count($lastNames)];
    $person3 = $firstNames[($hash + 5) % count($firstNames)] . ' ' . $lastNames[($hash + 6) % count($lastNames)];

    // 🔷 Article со всеми полями
    $schemaArticle = [
        "@context" => "https://schema.org",
        "@type" => "Article",
        "mainEntityOfPage" => [
            "@type" => "WebPage",
            "@id" => $fullUrl
        ],
        "headline" => $h1,
        "name" => $title,
        "description" => $description,
        "image" => $logo,
        "author" => [
            "@type" => "Person",
            "name" => $person1,
            "url" => "https://$domain/author-1-$domainZone/"
        ],
        "editor" => [
            "@type" => "Person",
            "name" => $person2,
            "url" => "https://$domain/author-2-$domainZone/"
        ],
        "contributor" => [
            "@type" => "Person",
            "name" => $person3,
            "url" => "https://$domain/author-3-$domainZone/"
        ],
        "publisher" => [
            "@type" => "Organization",
            "name" => $domainShort
        ],
        "datePublished" => $isoDate,
        "dateModified" => $isoDate
    ];
    $jsonLdArticle = '<script type="application/ld+json">' . json_encode($schemaArticle, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) . '</script>';

    // 🔷 Организация
    $schemaOrg = [
        "@context" => "https://schema.org",
        "@type" => "Organization",
        "name" => $domain,
        "url" => "https://$domain",
        "logo" => [
            "@type" => "ImageObject",
            "url" => $logo,
            "width" => 300,
            "height" => 60
        ],
        "sameAs" => [
            "https://vk.com/$domainShort",
            "https://facebook.com/$domainShort",
            "https://t.me/$domainShort"
        ],
        "description" => $description,
        "contactPoint" => [
            "@type" => "ContactPoint",
            "telephone" => $phone,
            "contactType" => "Customer Support",
            "areaServed" => "RU",
            "availableLanguage" => ["Russian"]
        ]
    ];
    $jsonLdOrg = '<script type="application/ld+json">' . json_encode($schemaOrg, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) . '</script>';

    // 🔷 WebSite с SearchAction
    $schemaWebSite = [
        "@context" => "https://schema.org",
        "@type" => "WebSite",
        "name" => $h1,
        "url" => "https://$domain",
        "potentialAction" => [
            "@type" => "SearchAction",
            "target" => "https://$domain/search?q={search_term_string}",
            "query-input" => "required name=search_term_string"
        ]
    ];
    $jsonLdWebsite = '<script type="application/ld+json">' . json_encode($schemaWebSite, JSON_UNESCAPED_UNICODE | JSON_UNESCAPED_SLASHES | JSON_PRETTY_PRINT) . '</script>';

    // 🔷 OpenGraph + Twitter
    $twitterHandle = '@' . preg_replace('/^www\./', '', $domain);
    $metaTags = <<<META
<meta property="og:type" content="article">
<meta property="og:title" content="$title">
<meta property="og:description" content="$description">
<meta property="og:url" content="$fullUrl">
<meta property="og:image" content="$logo">
<meta property="og:site_name" content="$domain">

<meta name="twitter:card" content="summary_large_image">
<meta name="twitter:title" content="$title">
<meta name="twitter:description" content="$description">
<meta name="twitter:image" content="$logo">
<meta name="twitter:site" content="$twitterHandle">
META;

    // 🔷 Возврат всех блоков
    return $jsonLdArticle
         . "\n" . $jsonLdOrg
         . "\n" . $jsonLdWebsite
         . "\n" . $metaTags;
}
